package jamezo97.clonecraft.block;

import jamezo97.clonecraft.CloneCraft;
import jamezo97.clonecraft.GuiHandler;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class BlockDNASequencer extends BlockContainer{

	public BlockDNASequencer(int id) {
		super(id, Material.rock);
		this.setTextureName("CloneCraft:sequencerSide");
	}

	@Override
	public TileEntity createNewTileEntity(World world) {
		return new TileEntityDNASequencer();
	}
	
	

	@Override
	public boolean onBlockActivated(World world, int i, int j, int k, EntityPlayer player, int par6, float par7, float par8, float par9) {
		player.openGui(CloneCraft.instance, GuiHandler.SEQUENCER, world, i, j, k);
		return true;
	}




	Icon top = null, bottom = null;
	
	@Override
	public void registerIcons(IconRegister ir) {
		super.registerIcons(ir);
		top = ir.registerIcon("CloneCraft:sequencerTop");
		bottom = ir.registerIcon("CloneCraft:sequencerBottom");
	}

	@Override
	public Icon getIcon(int side, int meta) {
		if(side == 0){
			return bottom;
		}else if(side == 1){
			return top;
		}
		return this.blockIcon;
	}
	
	
	
	

}
